/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.backup.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tp_link.eap.configuration.Configuration;
import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.domain.account.User;
import com.tp_link.eap.domain.cloud.CloudUser;
import com.tp_link.eap.domain.cloud.ModelFw;
import com.tp_link.eap.domain.eap.AlertInfo;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.Client;
import com.tp_link.eap.domain.eap.ClientHistory;
import com.tp_link.eap.domain.eap.LogInfo;
import com.tp_link.eap.domain.eap.Map;
import com.tp_link.eap.domain.eap.RogueAp;
import com.tp_link.eap.domain.eap.StatLifeClient;
import com.tp_link.eap.domain.eap.StatRADaily;
import com.tp_link.eap.domain.eap.StatRAHourly;
import com.tp_link.eap.domain.eap.bean.ClientRateLimitSetting;
import com.tp_link.eap.domain.eap.bean.IpSetting;
import com.tp_link.eap.domain.eap.bean.SsidOverride;
import com.tp_link.eap.domain.email.MailServer;
import com.tp_link.eap.domain.globalsetting.AccessSubnetGroup;
import com.tp_link.eap.domain.globalsetting.BandSteering;
import com.tp_link.eap.domain.globalsetting.FreeAuthenticationPolicy;
import com.tp_link.eap.domain.globalsetting.GlobalEnable;
import com.tp_link.eap.domain.globalsetting.HistoryRetentionSetting;
import com.tp_link.eap.domain.globalsetting.LogSetting;
import com.tp_link.eap.domain.globalsetting.ManagementVlanSetting;
import com.tp_link.eap.domain.globalsetting.PortalSetting;
import com.tp_link.eap.domain.globalsetting.Profile;
import com.tp_link.eap.domain.globalsetting.QosSetting;
import com.tp_link.eap.domain.globalsetting.SshSetting;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.StationMacList;
import com.tp_link.eap.domain.globalsetting.UserAccountSetting;
import com.tp_link.eap.domain.globalsetting.Wireless;
import com.tp_link.eap.domain.globalsetting.WlanGroup;
import com.tp_link.eap.domain.hotspot.LocalUser;
import com.tp_link.eap.domain.hotspot.Operator;
import com.tp_link.eap.domain.hotspot.Voucher;
import com.tp_link.eap.domain.mesh.bean.MeshRelation;
import com.tp_link.eap.domain.mesh.document.MeshSetting;
import com.tp_link.eap.domain.portal.Guest;
import com.tp_link.eap.domain.portal.PortalWebUIPicture;
import com.tp_link.eap.domain.roaming.document.RoamingSetting;
import com.tp_link.eap.domain.scheduler.AutoBackupSchedule;
import com.tp_link.eap.domain.scheduler.RebootSchedule;
import com.tp_link.eap.domain.scheduler.Schedule;
import com.tp_link.eap.domain.site.Privilege;
import com.tp_link.eap.domain.site.Site;
import com.tp_link.eap.domain.system.CSSetting;
import com.tp_link.eap.monitor.backup.impl.c;
import com.tp_link.eap.monitor.backup.impl.d;
import com.tp_link.eap.monitor.cloudkey.model.CloudKeyEntry;
import com.tp_link.eap.monitor.globalsetting.repo.ProfileRepository;
import com.tp_link.eap.monitor.globalsetting.repo.StationMacListRepository;
import com.tp_link.eap.monitor.globalsetting.repo.SubnetRepository;
import com.tp_link.eap.monitor.globalsetting.repo.WlanGroupRepository;
import com.tp_link.eap.monitor.globalsetting.service.i;
import com.tp_link.eap.monitor.globalsetting.service.l;
import com.tp_link.eap.monitor.globalsetting.service.m;
import com.tp_link.eap.monitor.globalsetting.service.n;
import com.tp_link.eap.monitor.hotspot.service.LocalUserServiceI;
import com.tp_link.eap.monitor.hotspot.service.OperatorServiceI;
import com.tp_link.eap.monitor.hotspot.service.VoucherServiceI;
import com.tp_link.eap.monitor.mesh.repo.StatMeshInfoRepository;
import com.tp_link.eap.monitor.monitor.repo.RogueRepository;
import com.tp_link.eap.monitor.monitor.service.f;
import com.tp_link.eap.monitor.monitor.service.g;
import com.tp_link.eap.monitor.monitor.service.h;
import com.tp_link.eap.monitor.monitor.service.j;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.user.service.CSSettingService;
import com.tp_link.eap.user.service.MailServerService;
import com.tp_link.eap.user.service.PrivilegeServiceI;
import com.tp_link.eap.user.service.RoleService;
import com.tp_link.eap.user.service.UserService;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.restore.a;
import com.tp_link.eap.util.restore.b;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="restoreService")
@Primary
public class RestoreServiceImpl
implements com.tp_link.eap.monitor.backup.c {
    private static final Logger a = LoggerFactory.getLogger(RestoreServiceImpl.class);
    private static final Configuration b = com.tp_link.eap.configuration.a.a((String)"netty.properties");
    private static final int c = Integer.parseInt(b.getProperty("restore.timeout"));
    private static final int d = 1000;
    private static List<MeshRelation> e = new ArrayList<MeshRelation>();
    private static List<String> f = new ArrayList<String>();
    private String g;
    @Autowired
    @Qualifier(value="oldRestoreService")
    private com.tp_link.eap.monitor.backup.c h;
    @Autowired
    private MongoTemplate i;
    @Autowired
    private com.tp_link.eap.monitor.task.service.a j;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b k;
    @Autowired
    private com.tp_link.eap.monitor.record.service.b l;
    @Autowired
    private com.tp_link.eap.monitor.mesh.service.c m;
    @Autowired
    private com.tp_link.eap.monitor.site.service.a n;
    @Autowired
    private UserService o;
    @Autowired
    private RoleService p;
    @Autowired
    private CSSettingService q;
    @Autowired
    private MailServerService r;
    @Autowired
    private PrivilegeServiceI s;
    @Autowired
    private com.tp_link.eap.monitor.cloud.clouduser.service.a t;
    @Autowired
    private RogueRepository u;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.d v;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.a w;
    @Autowired
    private StatMeshInfoRepository x;
    @Autowired
    private OperatorServiceI y;
    @Autowired
    private f z;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.d A;
    @Autowired
    private WlanGroupRepository B;
    @Autowired
    private m C;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.j D;
    @Autowired
    private l E;
    @Autowired
    private ProfileRepository F;
    @Autowired
    private StationMacListRepository G;
    @Autowired
    private n H;
    @Autowired
    private SubnetRepository I;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.c J;
    @Autowired
    private LocalUserServiceI K;
    @Autowired
    private VoucherServiceI L;
    @Autowired
    private h M;
    @Autowired
    private i N;
    @Autowired
    private com.tp_link.eap.monitor.cloudkey.service.a O;
    @Autowired
    private com.tp_link.eap.monitor.portal.service.b P;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.c Q;
    @Autowired
    private g R;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.a S;
    @Autowired
    private j T;
    @Autowired
    private com.tp_link.eap.monitor.cloud.device.service.a U;
    @Autowired
    private com.tp_link.eap.monitor.compatibility.service.a V;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OperationResponse restore(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        OperationResponse operationResponse;
        if (com.tp_link.eap.util.m.b.n()) {
            return new OperationResponse(ResErrorCode.cj);
        }
        com.tp_link.eap.util.m.b.l();
        try (InputStream inputStream = com.tp_link.eap.util.g.a.b((HttpServletRequest)request);){
            operationResponse = this.a(inputStream);
            if (!operationResponse.success()) {
                com.tp_link.eap.util.m.b.m();
                if (operationResponse.getErrorCode() == ResErrorCode.bp.a()) {
                    OperationResponse operationResponse2 = this.h.restore(request, response, controlType, reqObj);
                    return operationResponse2;
                }
            }
        }
        catch (Exception exception) {
            a.error(exception.toString(), (Throwable)exception);
            com.tp_link.eap.util.m.b.m();
            return new OperationResponse(ResErrorCode.bp);
        }
        com.tp_link.eap.util.m.b.m();
        return operationResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse a(InputStream inputStream) {
        OperationResponse operationResponse;
        Throwable throwable;
        try {
            throwable = null;
            try (CipherInputStream cipherInputStream = com.tp_link.eap.util.e.c.a((InputStream)inputStream);
                 GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)cipherInputStream);
                 JsonParser jsonParser = new JsonFactory().createParser((InputStream)gZIPInputStream);){
                com.tp_link.eap.util.restore.b.a((int)35);
                this.b();
                com.tp_link.eap.util.restore.b.b((int)1);
                jsonParser.setCodec((ObjectCodec)new ObjectMapper());
                boolean bl = true;
                while (!jsonParser.isClosed()) {
                    JsonToken jsonToken = jsonParser.nextToken();
                    if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
                    String string = jsonParser.getCurrentName();
                    jsonParser.nextToken();
                    a.debug("Restoring {} ...", (Object)string);
                    if (bl) {
                        bl = false;
                        operationResponse = this.a(string, jsonParser);
                        if (operationResponse.success()) {
                            this.c();
                            com.tp_link.eap.util.restore.b.b((int)1);
                            continue;
                        }
                        String string2 = operationResponse;
                        return string2;
                    }
                    switch (string) {
                        case "site": {
                            this.a(jsonParser);
                            break;
                        }
                        case "user": {
                            this.b(jsonParser);
                            break;
                        }
                        case "controllerSetting": {
                            this.c(jsonParser);
                            break;
                        }
                        case "mailServer": {
                            this.d(jsonParser);
                            break;
                        }
                        case "privilege": {
                            this.e(jsonParser);
                            break;
                        }
                        case "modelFirmware": {
                            this.f(jsonParser);
                            break;
                        }
                        case "globalSetting": {
                            this.g(jsonParser);
                            break;
                        }
                        case "mesh": {
                            this.w(jsonParser);
                            break;
                        }
                        case "roaming": {
                            this.x(jsonParser);
                            break;
                        }
                        case "historyRetention": {
                            this.v(jsonParser);
                            break;
                        }
                        case "schedule": {
                            this.y(jsonParser);
                            break;
                        }
                        case "ap": {
                            this.z(jsonParser);
                            break;
                        }
                        case "apAssociation": {
                            this.A(jsonParser);
                            break;
                        }
                        case "rogue": {
                            this.B(jsonParser);
                            break;
                        }
                        case "blockClients": {
                            this.C(jsonParser);
                            break;
                        }
                        case "rateLimitClients": {
                            this.D(jsonParser);
                            break;
                        }
                        case "accessSubnetGroups": {
                            this.E(jsonParser);
                            break;
                        }
                        case "hotspot": {
                            this.F(jsonParser);
                            break;
                        }
                        case "localUser": {
                            this.G(jsonParser);
                            break;
                        }
                        case "voucher": {
                            this.H(jsonParser);
                            break;
                        }
                        case "portalImg": {
                            this.I(jsonParser);
                            break;
                        }
                        case "portalImgFile": {
                            this.K(jsonParser);
                            break;
                        }
                        case "map": {
                            this.J(jsonParser);
                            break;
                        }
                        case "mapFile": {
                            this.K(jsonParser);
                            break;
                        }
                        case "cloudKey": {
                            this.L(jsonParser);
                            break;
                        }
                        case "authInfo": {
                            this.M(jsonParser);
                            break;
                        }
                        case "clientHistory": {
                            this.N(jsonParser);
                            break;
                        }
                        case "logs": {
                            this.O(jsonParser);
                            break;
                        }
                        case "alerts": {
                            this.P(jsonParser);
                            break;
                        }
                        case "raHourly": {
                            this.Q(jsonParser);
                            break;
                        }
                        case "raDaily": {
                            this.R(jsonParser);
                            break;
                        }
                        case "statClient": {
                            this.S(jsonParser);
                            break;
                        }
                        default: {
                            a.error("Unknown json field {}", (Object)string);
                        }
                    }
                    com.tp_link.eap.util.restore.b.b((int)1);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException iOException) {
            this.h();
            e.clear();
            f.clear();
            a.warn(iOException.toString(), (Throwable)iOException);
            throwable = new OperationResponse(ResErrorCode.bp);
            return throwable;
        }
        finally {
            com.tp_link.eap.util.restore.b.a();
        }
        this.V.a(this.g);
        operationResponse = this.d();
        e.clear();
        f.clear();
        return operationResponse;
    }

    @Override
    public OperationResponse a(String string) {
        return com.tp_link.eap.util.e.aY;
    }

    private void b() {
        List<Ap> list = this.k.getAdoptAps();
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                int n2 = this.m.getHop(ap.getMac());
                MeshRelation meshRelation = new MeshRelation();
                meshRelation.setMac(ap.getMac());
                meshRelation.setHop(Integer.valueOf(n2));
                if (ap.getMeshConf() != null && !CollectionUtils.isEmpty((Collection)ap.getMeshConf().getChildApMacs())) {
                    meshRelation.setChildApMacs(ap.getMeshConf().getChildApMacs());
                }
                e.add(meshRelation);
            }
        }
    }

    private void c() {
        this.j.deletAllSchedules();
        a.debug("Clearing site config...");
        List<Site> list = this.n.getSites();
        for (Site site : list) {
            this.n.deleteConfigBySite(site.getSiteName());
        }
        a.debug("Clearing statistic...");
        this.T.deleteAll();
        a.debug("Clearing client...");
        this.v.deleteAll();
        a.debug("Clearing client history...");
        this.Q.deleteAll();
        a.debug("Clearing alert...");
        this.S.deleteAll();
        a.debug("Clearing map...");
        this.M.deleteAll();
        a.debug("Clearing site...");
        this.n.deleteAllSites();
        a.debug("Clearing user...");
        this.o.deleteAllExceptDefault();
        a.debug("Clearing privilege...");
        this.s.deleteAllPrivileges();
        a.debug("Clearing model firmware...");
        this.z.deleteAll();
        a.debug("Clearing wlan group...");
        this.B.deleteAll();
        a.debug("Clearing station mac list...");
        this.C.deleteAll();
        a.debug("Clearing profile...");
        this.D.deleteAll();
        a.debug("Clearing ssid...");
        this.E.deleteAll(false);
        a.debug("Clearing free authentication service...");
        this.J.deleteAll();
        a.debug("Clearing rogue ap...");
        this.u.deleteAll();
        a.debug("Clearing subnet group...");
        this.w.deleteAllSubnetGroups();
        a.debug("Clearing stat mesh info...");
        this.x.deleteAll();
        a.debug("Clearing operator...");
        this.y.deleteAll();
        a.debug("Clearing local user...");
        this.K.deleteAll();
        a.debug("Clearing voucher...");
        this.L.deleteAll();
        a.debug("Clearing web UI element...");
        this.N.deleteAllRecordsAndFiles();
        a.debug("Clearing logs...");
        this.R.deleteAllLogs();
    }

    private OperationResponse d() {
        List<Ap> list = this.k.getAdoptAps();
        ArrayList<Ap> arrayList = new ArrayList<Ap>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.a(list, arrayList, arrayList2);
        this.a(arrayList2);
        if (!CollectionUtils.isEmpty(arrayList2)) {
            a.warn("After forget mesh relation, forgetApMacList is not empty");
            this.k.forgetApsByHop(arrayList2);
        }
        if (CollectionUtils.isEmpty(arrayList)) {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(1);
            hashMap.put("data", Boolean.TRUE);
            return new OperationResponse(ResErrorCode.a, hashMap);
        }
        this.b(arrayList);
        return com.tp_link.eap.util.e.bd;
    }

    private void a(List<Ap> list, List<Ap> list2, List<String> list3) {
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                String string = ap.getMac();
                a.debug("AP mac is {}", (Object)string);
                if (!CollectionUtils.isEmpty(f) && f.contains(string)) {
                    a.debug("{} exist in backup file", (Object)string);
                    if (ap.getStatus() == 0) {
                        this.l.refreshVersion(string);
                    } else {
                        list2.add(ap);
                    }
                    f.remove(string);
                    continue;
                }
                a.debug("Forget AP {}", (Object)string);
                list3.add(ap.getMac());
            }
        }
    }

    private void a(List<String> list) {
        if (!CollectionUtils.isEmpty(e)) {
            Collections.sort(e, new c(this));
            int n2 = e.get(0).getHop();
            for (MeshRelation meshRelation : e) {
                if (meshRelation.getHop() < n2) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        a.warn(interruptedException.toString(), (Throwable)interruptedException);
                    }
                }
                n2 = meshRelation.getHop();
                if (list.contains(meshRelation.getMac())) {
                    Ap ap = this.k.getApByMac(meshRelation.getMac());
                    if (ap == null) continue;
                    this.k.forgetAp(ap.getId());
                    list.remove(meshRelation.getMac());
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)meshRelation.getChildApMacs())) continue;
                a.debug("sendBatchDisconnectCommand: " + meshRelation.getMac() + " " + meshRelation.getHop());
                this.m.sendBatchDisconnectCommand(meshRelation.getMac(), meshRelation.getChildApMacs());
            }
        }
    }

    private void b(List<Ap> list) {
        List<Ap> list2 = list;
        int n2 = list2.size();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ExecutorService executorService2 = Executors.newSingleThreadExecutor();
        com.tp_link.eap.util.restore.c.b((int)n2);
        executorService2.execute(new com.tp_link.eap.monitor.backup.a.a(c));
        executorService.execute(new d(this, list2, n2));
    }

    private int e() {
        Configuration configuration = com.tp_link.eap.configuration.a.a((String)"netty.properties");
        return Integer.parseInt(configuration.getProperty("restore.threshold"));
    }

    private OperationResponse a(String string, JsonParser jsonParser) throws IOException {
        if (!string.equals("ver")) {
            return new OperationResponse(ResErrorCode.bn);
        }
        this.g = jsonParser.getValueAsString();
        OperationResponse operationResponse = this.b(this.g);
        if (!operationResponse.success()) {
            a.warn("Not compatible {}", (Object)this.g);
            return operationResponse;
        }
        return com.tp_link.eap.util.e.bd;
    }

    private OperationResponse b(String string) {
        Configuration configuration = com.tp_link.eap.configuration.a.a((String)"eap.properties");
        String string2 = configuration.getProperty("eap.version");
        boolean bl = com.tp_link.eap.util.m.a.a((String)string, (String)string2);
        if (bl) {
            return com.tp_link.eap.util.e.bd;
        }
        return new OperationResponse(ResErrorCode.bo, "Restore file is not compatible with Omada Controller " + string2, null);
    }

    private void a(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Site site = (Site)jsonParser.readValueAs(Site.class);
            site.setId(null);
            site.setSiteName(com.tp_link.eap.util.a.e.e((String)site.getSiteName()));
            this.i.save((Object)site);
        }
    }

    private void b(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            User user = (User)jsonParser.readValueAs(User.class);
            user.setName(com.tp_link.eap.util.a.e.e((String)user.getName()));
            user.setEmail(com.tp_link.eap.util.a.e.e((String)user.getEmail()));
            user.setRoleName(com.tp_link.eap.util.a.e.e((String)user.getRoleName()));
            Site site = this.n.getSiteBySiteName(user.getLastSite());
            if (null == site) {
                user.setLastSite("Default");
            }
            Role role = this.p.getRoleByName(user.getRoleName());
            user.setRole(role);
            this.o.restoreUser(user);
        }
    }

    private void c(JsonParser jsonParser) throws IOException {
        CSSetting cSSetting = (CSSetting)jsonParser.readValueAs(CSSetting.class);
        this.q.setCSSetting(cSSetting);
        this.U.setControllerName(cSSetting.getControllerName());
    }

    private void d(JsonParser jsonParser) throws IOException {
        MailServer mailServer = (MailServer)jsonParser.readValueAs(MailServer.class);
        this.r.setMailServer(mailServer);
    }

    private void e(JsonParser jsonParser) throws IOException {
        ArrayList<Privilege> arrayList = new ArrayList<Privilege>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Privilege privilege = (Privilege)jsonParser.readValueAs(Privilege.class);
            User user = this.o.getUserByName(privilege.getUserName());
            if (null == user) {
                Operator operator = this.y.getOperByName(privilege.getUserName());
                if (null == operator) continue;
                privilege.setRole(operator.getRole());
            } else {
                privilege.setRole(user.getRole());
            }
            arrayList.add(privilege);
        }
        this.s.savePrivlileges(arrayList);
        this.o.resetDefaultUserLastSite();
        this.f();
        this.g();
    }

    private void f() {
        List list = this.o.getAll();
        List<Site> list2 = this.n.getSites();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (User user : list) {
                if (!user.isDefault()) continue;
                for (Site site : list2) {
                    Privilege privilege = this.s.findPrivilegeByUserNameAndSiteName(user.getName(), site.getSiteName());
                    if (null == privilege) {
                        a.debug("Assign user {} to site {}", (Object)user.getName(), (Object)site.getSiteName());
                        this.s.assignSiteToUser(user.getName(), site.getSiteName(), user.getRole());
                        continue;
                    }
                    a.debug("Set user {} role to site {} privilege", (Object)user.getName(), (Object)site.getSiteName());
                    privilege.setRole(user.getRole());
                    this.s.savePrivilege(privilege);
                }
            }
        }
    }

    private void g() {
        CloudUser cloudUser = this.t.getOwner();
        if (null != cloudUser) {
            List<Site> list = this.n.getSites();
            for (Site site : list) {
                Privilege privilege = this.s.findPrivilegeByUserNameAndSiteName(cloudUser.getAccountIdEncrypted(), site.getSiteName());
                if (null == privilege) {
                    a.debug("Assign user {} to site {}", (Object)cloudUser.getAccountIdEncrypted(), (Object)site.getSiteName());
                    this.s.assignSiteToUser(cloudUser.getAccountIdEncrypted(), site.getSiteName(), cloudUser.getRole());
                    continue;
                }
                a.debug("Modify user {} to site {} privilege", (Object)cloudUser.getAccountIdEncrypted(), (Object)site.getSiteName());
                privilege.setRole(cloudUser.getRole());
                this.s.savePrivilege(privilege);
            }
        }
    }

    private void f(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            ModelFw modelFw = (ModelFw)jsonParser.readValueAs(ModelFw.class);
            if (modelFw.getCategory() == ModelFw.DeviceCategory.CLOUD_KEY.getCategory()) continue;
            modelFw.setId(null);
            this.z.refreshModelInfo(modelFw);
        }
        this.z.cleanExpiredFw();
    }

    private void g(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            JsonToken jsonToken;
            block33: while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_OBJECT) {
                if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
                String string = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (string) {
                    case "wlanGroup": {
                        this.h(jsonParser);
                        continue block33;
                    }
                    case "globalEnable": {
                        this.i(jsonParser);
                        continue block33;
                    }
                    case "ssh": {
                        this.j(jsonParser);
                        continue block33;
                    }
                    case "managementVlan": {
                        this.k(jsonParser);
                        continue block33;
                    }
                    case "wireless": {
                        this.l(jsonParser);
                        continue block33;
                    }
                    case "userAccount": {
                        this.m(jsonParser);
                        continue block33;
                    }
                    case "qos": {
                        this.n(jsonParser);
                        continue block33;
                    }
                    case "portalList": {
                        this.o(jsonParser);
                        continue block33;
                    }
                    case "log": {
                        this.p(jsonParser);
                        continue block33;
                    }
                    case "station": {
                        this.q(jsonParser);
                        continue block33;
                    }
                    case "profile": {
                        this.r(jsonParser);
                        continue block33;
                    }
                    case "ssid": {
                        this.s(jsonParser);
                        continue block33;
                    }
                    case "fap": {
                        this.t(jsonParser);
                        continue block33;
                    }
                    case "bandSteering": {
                        this.u(jsonParser);
                        continue block33;
                    }
                }
                a.warn("Restoring global setting, unrecognized filed {}", (Object)jsonParser.getCurrentName());
            }
        }
    }

    private void h(JsonParser jsonParser) throws IOException {
        ArrayList<WlanGroup> arrayList = new ArrayList<WlanGroup>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            WlanGroup wlanGroup = (WlanGroup)jsonParser.readValueAs(WlanGroup.class);
            arrayList.add(wlanGroup);
        }
        this.B.save(arrayList);
    }

    private void i(JsonParser jsonParser) throws IOException {
        GlobalEnable globalEnable = (GlobalEnable)jsonParser.readValueAs(GlobalEnable.class);
        if (null == globalEnable.getSite()) {
            globalEnable.setSite("Default");
        }
        com.tp_link.eap.d.b.b((String)globalEnable.getSite());
        this.A.saveGlobalEnable(globalEnable, false);
    }

    private void j(JsonParser jsonParser) throws IOException {
        SshSetting sshSetting = (SshSetting)jsonParser.readValueAs(SshSetting.class);
        if (null == sshSetting.getSite()) {
            sshSetting.setSite("Default");
        }
        com.tp_link.eap.d.b.b((String)sshSetting.getSite());
        this.A.saveSshSetting(sshSetting, false);
    }

    private void k(JsonParser jsonParser) throws IOException {
        ManagementVlanSetting managementVlanSetting = (ManagementVlanSetting)jsonParser.readValueAs(ManagementVlanSetting.class);
        if (null == managementVlanSetting.getSite()) {
            managementVlanSetting.setSite("Default");
        }
        com.tp_link.eap.d.b.b((String)managementVlanSetting.getSite());
        this.A.saveManagementVlanSetting(managementVlanSetting, false);
    }

    private void l(JsonParser jsonParser) throws IOException {
        Wireless wireless = (Wireless)jsonParser.readValueAs(Wireless.class);
        if (null == wireless.getSite()) {
            wireless.setSite("Default");
        }
        com.tp_link.eap.d.b.b((String)wireless.getSite());
        this.A.saveWirelessSetting(wireless, 2, false);
    }

    private void m(JsonParser jsonParser) throws IOException {
        UserAccountSetting userAccountSetting = (UserAccountSetting)jsonParser.readValueAs(UserAccountSetting.class);
        if (null == userAccountSetting.getSite()) {
            userAccountSetting.setSite("Default");
        }
        com.tp_link.eap.d.b.b((String)userAccountSetting.getSite());
        UserAccountSetting userAccountSetting2 = this.A.getUserAccountSetting();
        if (null != userAccountSetting2) {
            userAccountSetting.setOldName(userAccountSetting2.getUserName());
            userAccountSetting.setOldPassword(userAccountSetting2.getPassword());
        }
        this.A.saveUserAccountSetting(userAccountSetting, false);
    }

    private void n(JsonParser jsonParser) throws IOException {
        QosSetting qosSetting = (QosSetting)jsonParser.readValueAs(QosSetting.class);
        if (null == qosSetting.getSite()) {
            qosSetting.setSite("Default");
        }
        com.tp_link.eap.d.b.b((String)qosSetting.getSite());
        this.A.saveQosSetting(qosSetting, 2, false);
    }

    private void o(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            PortalSetting portalSetting = (PortalSetting)jsonParser.readValueAs(PortalSetting.class);
            portalSetting.setPortalName(com.tp_link.eap.util.a.e.e((String)portalSetting.getPortalName()));
            if (null == portalSetting.getSite()) {
                portalSetting.setSite("Default");
            }
            com.tp_link.eap.d.b.b((String)portalSetting.getSite());
            if (null == portalSetting.getPortalTitle()) {
                portalSetting.setPortalTitle("");
            }
            if (null == portalSetting.getPortalUseTerm()) {
                portalSetting.setPortalUseTerm("");
            }
            if (null == portalSetting.getDailyLimitEnable()) {
                portalSetting.setDailyLimitEnable(Boolean.valueOf(false));
            }
            this.A.savePortalSetting(portalSetting, false);
        }
    }

    private void p(JsonParser jsonParser) throws IOException {
        LogSetting logSetting = (LogSetting)jsonParser.readValueAs(LogSetting.class);
        if (null == logSetting.getSite()) {
            logSetting.setSite("Default");
        }
        com.tp_link.eap.d.b.b((String)logSetting.getSite());
        this.A.saveLogSetting(logSetting, false);
    }

    private void q(JsonParser jsonParser) throws IOException {
        Object object;
        ArrayList<StationMacList> arrayList = new ArrayList<StationMacList>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            object = (StationMacList)jsonParser.readValueAs(StationMacList.class);
            object.setName(com.tp_link.eap.util.a.e.e((String)object.getName()));
            arrayList.add((StationMacList)object);
        }
        if (!CollectionUtils.isEmpty(arrayList)) {
            object = ((StationMacList)arrayList.get(0)).getSite();
            com.tp_link.eap.d.b.b((String)(null == object ? "Default" : object));
            this.C.saveBatchSationMacList(arrayList);
        }
    }

    private void r(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Profile profile = (Profile)jsonParser.readValueAs(Profile.class);
            profile.setName(com.tp_link.eap.util.a.e.e((String)profile.getName()));
            if (null == profile.getSite()) {
                profile.setSite("Default");
            }
            com.tp_link.eap.d.b.b((String)profile.getSite());
            this.D.saveProfile(profile, false);
        }
    }

    private void s(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            WlanGroup wlanGroup;
            Profile profile;
            Ssid ssid = (Ssid)jsonParser.readValueAs(Ssid.class);
            if (null == ssid.getSite()) {
                ssid.setSite("Default");
            }
            com.tp_link.eap.d.b.b((String)ssid.getSite());
            ssid.setId(null);
            if (null != ssid.getSchedulerName() && null != (profile = this.F.findByNameAndSite(ssid.getSchedulerName(), ssid.getSite()))) {
                ssid.setSchedulerId(profile.getId());
            }
            if (null != ssid.getFilterName() && null != (profile = this.G.findByNameAndSite(ssid.getFilterName(), ssid.getSite()))) {
                ssid.setMacFilterId(profile.getId());
            }
            if (null != ssid.getWlanName()) {
                profile = this.H.getBySiteAndRadioIdAndName(ssid.getSite(), ssid.getRadioId(), ssid.getWlanName());
                if (null != profile) {
                    ssid.setWlanId(profile.getWlanId());
                } else {
                    wlanGroup = this.H.getDefWlanByRadioId(0);
                    WlanGroup wlanGroup2 = this.H.getDefWlanByRadioId(1);
                    ssid.setWlanId(ssid.getRadioId() == 0 ? wlanGroup.getWlanId() : wlanGroup2.getWlanId());
                }
            } else {
                profile = this.H.getDefWlanByRadioId(0);
                wlanGroup = this.H.getDefWlanByRadioId(1);
                ssid.setWlanId(ssid.getRadioId() == 0 ? profile.getWlanId() : wlanGroup.getWlanId());
            }
            profile = this.I.findByGroupNameAndSite(ssid.getAccessControlRuleName(), ssid.getSite());
            if (null != profile) {
                ssid.setAccessControlRule(profile.getId());
            } else {
                ssid.setAccessControlRule("None");
                ssid.setAccessControlRuleName("None");
                ssid.setAccessControl(Boolean.valueOf(false));
            }
            this.E.saveSsid(ssid, 0, false, null);
        }
    }

    private void t(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            FreeAuthenticationPolicy freeAuthenticationPolicy = (FreeAuthenticationPolicy)jsonParser.readValueAs(FreeAuthenticationPolicy.class);
            freeAuthenticationPolicy.setName(com.tp_link.eap.util.a.e.e((String)freeAuthenticationPolicy.getName()));
            freeAuthenticationPolicy.setUrl(com.tp_link.eap.util.a.e.e((String)freeAuthenticationPolicy.getUrl()));
            freeAuthenticationPolicy.setSourceIpRange(com.tp_link.eap.util.a.e.e((String)freeAuthenticationPolicy.getSourceIpRange()));
            freeAuthenticationPolicy.setDestinationIpRange(com.tp_link.eap.util.a.e.e((String)freeAuthenticationPolicy.getDestinationIpRange()));
            freeAuthenticationPolicy.setSourceMac(com.tp_link.eap.util.a.e.e((String)freeAuthenticationPolicy.getSourceMac()));
            if (null == freeAuthenticationPolicy.getSite()) {
                freeAuthenticationPolicy.setSite("Default");
            }
            com.tp_link.eap.d.b.b((String)freeAuthenticationPolicy.getSite());
            this.J.saveFreeAuthenticationPolicy(freeAuthenticationPolicy, false);
        }
    }

    private void u(JsonParser jsonParser) throws IOException {
        BandSteering bandSteering = (BandSteering)jsonParser.readValueAs(BandSteering.class);
        bandSteering.setId(null);
        this.i.save((Object)bandSteering);
    }

    private void v(JsonParser jsonParser) throws IOException {
        HistoryRetentionSetting historyRetentionSetting = (HistoryRetentionSetting)jsonParser.readValueAs(HistoryRetentionSetting.class);
        this.A.saveHistoryRetentionSetting(historyRetentionSetting);
    }

    private void w(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            MeshSetting meshSetting = (MeshSetting)jsonParser.readValueAs(MeshSetting.class);
            if (null == meshSetting.getSite()) {
                a.warn("Restoring mesh setting, and its site is null");
                meshSetting.setSite("Default");
            }
            this.i.save((Object)meshSetting);
        }
    }

    private void x(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            RoamingSetting roamingSetting = (RoamingSetting)jsonParser.readValueAs(RoamingSetting.class);
            if (null == roamingSetting.getSite()) {
                a.warn("Restoring roaming setting, and its site is null");
                roamingSetting.setSite("Default");
            }
            this.i.save((Object)roamingSetting);
        }
    }

    private void y(JsonParser jsonParser) throws IOException {
        this.j.deletAllSchedules();
        block8: while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            String string;
            JSONObject jSONObject = (JSONObject)jsonParser.readValueAs(JSONObject.class);
            switch (string = jSONObject.optString("scheduleType")) {
                case "Reboot": {
                    RebootSchedule rebootSchedule = (RebootSchedule)com.tp_link.eap.util.a.b.a((Object)jSONObject, RebootSchedule.class);
                    com.tp_link.eap.d.b.b((String)rebootSchedule.getSite());
                    this.j.addSchedule((Schedule)rebootSchedule);
                    continue block8;
                }
                case "AutoBackup": {
                    AutoBackupSchedule autoBackupSchedule = (AutoBackupSchedule)com.tp_link.eap.util.a.b.a((Object)jSONObject, AutoBackupSchedule.class);
                    com.tp_link.eap.d.b.b((String)"Default");
                    this.j.addSchedule((Schedule)autoBackupSchedule);
                    continue block8;
                }
            }
            a.warn("Restoring schedule, unknown type {}", (Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void z(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Object object;
            Ap ap = (Ap)jsonParser.readValueAs(Ap.class);
            String string = ap.getMac();
            if (null == string) continue;
            Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
            synchronized (object2) {
                Ap ap2 = this.k.getApDetail(string);
                if (null == ap2) {
                    if (this.c("2.7.0")) {
                        ap2 = new Ap();
                        ap2.setMac(string);
                        ap2.setAdopted(true);
                        ap2.setStatus(Integer.valueOf(0));
                    } else {
                        continue;
                    }
                }
                if (!ap2.isAdopted()) {
                    if (this.c("2.7.0")) {
                        ap2.setAdopted(true);
                        ap2.setStatus(Integer.valueOf(0));
                    } else {
                        continue;
                    }
                }
                f.add(string);
                this.a(ap2, ap);
                this.b(ap2, ap);
                ap2.setMeshConf(null);
                this.k.refreshAp(ap2);
                com.tp_link.eap.d.b.b((String)string, (String)ap2.getSite());
            }
        }
    }

    private void a(Ap ap, Ap ap2) {
        String string = ap.getMac();
        String string2 = ap2.getSite();
        if (null != string2) {
            if (!ap.getSite().equals(string2)) {
                this.k.deleteApStats(string, ap.getSite());
            }
            com.tp_link.eap.a.b.a((Ap)ap);
            ap.setSite(string2);
            if (null != ap2.getWlan2g() && null != ap2.getWlanGroupId2G()) {
                ap.setWlan2g(com.tp_link.eap.util.a.e.e((String)ap2.getWlan2g()));
                ap.setWlanGroupId2G(ap2.getWlanGroupId2G());
            }
            if (null != ap2.getWlan5g() && null != ap2.getWlanGroupId5G()) {
                ap.setWlan5g(com.tp_link.eap.util.a.e.e((String)ap2.getWlan5g()));
                ap.setWlanGroupId5G(ap2.getWlanGroupId5G());
            }
        } else {
            String string3 = "Default";
            com.tp_link.eap.d.b.b((String)string3);
            ap.setSite(string3);
            WlanGroup wlanGroup = this.H.getDefWlanByRadioId(0);
            if (null != wlanGroup) {
                ap.setWlanGroupId2G(wlanGroup.getWlanId());
                ap.setWlan2g(wlanGroup.getName());
            }
            if (null != (wlanGroup = this.H.getDefWlanByRadioId(1))) {
                ap.setWlanGroupId5G(wlanGroup.getWlanId());
                ap.setWlan5g(wlanGroup.getName());
            }
        }
    }

    private void b(Ap ap, Ap ap2) {
        if (null != ap2.getName()) {
            ap.setName(com.tp_link.eap.util.l.g((String)ap2.getName()));
        }
        if (null != ap2.getIp()) {
            ap.setIp(ap2.getIp());
        }
        if (null != ap2.getModel()) {
            ap.setModel(ap2.getModel());
        }
        if (null != ap2.getVersion()) {
            ap.setVersion(ap2.getVersion());
        }
        if (null != ap2.getModelVersion()) {
            ap.setModelVersion(ap2.getModelVersion());
        }
        if (null != ap2.getModelModelVersion()) {
            ap.setModelModelVersion(ap2.getModelModelVersion());
        }
        if (null != ap2.getHwVersion()) {
            ap.setHwVersion(ap2.getHwVersion());
        }
        if (null != ap2.getAdoptInfo()) {
            ap.setAdoptInfo(ap2.getAdoptInfo());
        }
        if (null != ap2.getDeviceMisc()) {
            ap.setDeviceMisc(ap2.getDeviceMisc());
        }
        if (null != ap2.getIpSetting()) {
            this.a(ap, ap2.getIpSetting());
            ap.setIpSetting(ap2.getIpSetting());
        }
        ap.setBindVlan(null);
        ap.setLanPortSettings(null);
        if (null != ap2.getBindVlan()) {
            ap.setBindVlan(ap2.getBindVlan());
        }
        if (null != ap2.getLanPortSettings()) {
            ap.setLanPortSettings(ap2.getLanPortSettings());
        }
        ap.setRogueStatus(ap2.isRogueStatus());
        if (null != ap2.getDeviceMisc() && !StringUtils.isEmpty((Object)ap2.getDeviceMisc().getCustomizeRegion())) {
            a.debug("new restore file checked, override radio config with file...");
            if (null != ap2.getRadio()) {
                ap.setRadio(ap2.getRadio());
            }
            if (null != ap2.getRadio5g()) {
                ap.setRadio5g(ap2.getRadio5g());
            }
        }
        if (null != ap2.getLoadBalance()) {
            ap.setLoadBalance(ap2.getLoadBalance());
        }
        if (null != ap2.getLoadBalance5g()) {
            ap.setLoadBalance5g(ap2.getLoadBalance5g());
        }
        if (null != ap2.getRssi()) {
            ap.setRssi(ap2.getRssi());
        }
        if (null != ap2.getRssi5g()) {
            ap.setRssi5g(ap2.getRssi5g());
        }
        if (null != ap2.getTrunkSetting()) {
            ap.setTrunkSetting(ap2.getTrunkSetting());
        }
        this.a(ap, 0, ap2.getSsidOverrides());
        this.a(ap, 1, ap2.getSsidOverrides5g());
        if (null != ap2.getWirelessLinked()) {
            ap.setWirelessLinked(ap2.getWirelessLinked());
        }
        if (null != ap2.getControllerSetting()) {
            ap.setControllerSetting(ap2.getControllerSetting());
        }
        if (null != ap2.getLocation()) {
            ap.setLocation(ap2.getLocation());
        }
    }

    private void a(Ap ap, Integer n2, List<SsidOverride> list) {
        if (!CollectionUtils.isEmpty(list)) {
            List<Ssid> list2 = this.E.getSsidsByRadioIdAndWlanId(n2, n2 == 0 ? ap.getWlanGroupId2G() : ap.getWlanGroupId5G());
            if (!CollectionUtils.isEmpty(list2)) {
                for (SsidOverride ssidOverride : list) {
                    String string = ssidOverride.getGlobalSsid();
                    for (Ssid ssid : list2) {
                        if (!ssid.getName().equals(string)) continue;
                        ssidOverride.setIndex(ssid.getIdInt().intValue());
                    }
                }
            } else {
                list = null;
            }
        } else {
            list = null;
        }
        if (n2 == 0) {
            ap.setSsidOverrides(list);
        } else {
            ap.setSsidOverrides5g(list);
        }
    }

    private void A(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Profile profile;
            String string;
            JsonToken jsonToken;
            String string2 = null;
            String string3 = null;
            Boolean bl = null;
            block11: while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_OBJECT) {
                if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
                string = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (string) {
                    case "apMac": {
                        string2 = jsonParser.getValueAsString();
                        continue block11;
                    }
                    case "profileName": {
                        string3 = jsonParser.getValueAsString();
                        continue block11;
                    }
                    case "schedulerAction": {
                        bl = jsonParser.getBooleanValue();
                    }
                }
                a.warn("Restoring ap association, unrecognized filed {}", (Object)jsonParser.getCurrentName());
            }
            if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3) || null == bl) continue;
            string = this.k.getApByMac(string2);
            if (null == string) {
                a.debug("AP {} not exit", string2);
                continue;
            }
            String string4 = string.getSite();
            if (null == string4) {
                a.debug("AP site is empty");
                string4 = "Default";
            }
            if (null == (profile = this.F.findByNameAndSite(string3, string4))) {
                a.debug("Profile {} not exist in site {}", (Object)string3, (Object)string4);
                continue;
            }
            string.setSchedulerAction(bl);
            string.setSchedulerId(profile.getId());
            this.k.refreshAp((Ap)string);
        }
    }

    private void a(Ap ap, IpSetting ipSetting) {
        boolean bl = false;
        IpSetting ipSetting2 = ap.getIpSetting();
        if (null == ipSetting2) {
            return;
        }
        bl = this.k.checkIpChange(ipSetting2, ipSetting);
        if (bl) {
            com.tp_link.eap.util.restore.a.a((String)ap.getMac());
        }
    }

    private void B(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            RogueAp rogueAp = (RogueAp)jsonParser.readValueAs(RogueAp.class);
            this.u.save(rogueAp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void C(JsonParser jsonParser) throws IOException {
        List<Client> list;
        List<Client> list2;
        List<Client> list3 = this.v.getAllBlockClients();
        if (!CollectionUtils.isEmpty(list3)) {
            for (Object object3 : list3) {
                list = list2 = com.tp_link.eap.b.b.a.b((String)object3.getMac());
                synchronized (list) {
                    object3.setBlock(false);
                    this.v.refreshClient((Client)object3);
                }
            }
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Object object;
            Object object2;
            Object object3;
            Client client = (Client)jsonParser.readValueAs(Client.class);
            object3 = com.tp_link.eap.util.a.e.e((String)client.getMac());
            if (null == object3) continue;
            client.setMac((String)object3);
            list2 = client.getSite();
            if (null == list2) {
                list2 = "Default";
                client.setSite((String)((Object)list2));
            }
            com.tp_link.eap.d.b.b((String)((Object)list2));
            list = this.v.getSiteBlockClients((String)((Object)list2));
            if (null != list && list.size() >= 500) continue;
            Client client2 = this.v.getClient((String)object3, (String)((Object)list2));
            if (null != client2) {
                if (client2.isActive()) {
                    this.v.block((String)object3);
                    continue;
                }
                object = object2 = com.tp_link.eap.b.b.a.b((String)object3);
                synchronized (object) {
                    client2.setBlock(true);
                    this.v.refreshClient(client2);
                    continue;
                }
            }
            client.setActive(false);
            client.setBlock(true);
            client.setFirstSeen(client.getLastSeen());
            object = object2 = com.tp_link.eap.b.b.a.b((String)object3);
            synchronized (object) {
                this.v.refreshClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void D(JsonParser jsonParser) throws IOException {
        Object object;
        Object object2;
        List<Client> list = this.v.getClients();
        if (!CollectionUtils.isEmpty(list)) {
            for (Object object3 : list) {
                if (null == object3.getClientRateLimitSetting()) continue;
                object = object2 = com.tp_link.eap.b.b.a.b((String)object3.getMac());
                synchronized (object) {
                    object3.setClientRateLimitSetting(null);
                    this.v.refreshClient((Client)object3);
                    this.T.refreshRateLimit((Client)object3);
                }
            }
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Object object4;
            Object object5;
            Integer n2;
            Object object3;
            Client client = (Client)jsonParser.readValueAs(Client.class);
            object3 = com.tp_link.eap.util.a.e.e((String)client.getMac());
            if (null == object3) continue;
            client.setMac((String)object3);
            object2 = client.getSite();
            if (null == object2) {
                object2 = "Default";
                client.setSite((String)object2);
            }
            if (null == (object = client.getClientRateLimitSetting()) || null == object.getDownloadRateLimit() || null == object.getUploadRateLimit() || object.getDownloadRateLimit() < 0L || object.getUploadRateLimit() < 0L || (n2 = this.v.getClientRateLimitCount((String)object2)) >= 3000) continue;
            Client client2 = this.v.getClient((String)object3, (String)object2);
            if (null != client2) {
                object4 = object5 = com.tp_link.eap.b.b.a.b((String)object3);
                synchronized (object4) {
                    client2.setClientRateLimitSetting((ClientRateLimitSetting)object);
                    this.v.refreshClient(client2);
                    this.T.refreshRateLimit(client2);
                    continue;
                }
            }
            if (object.getDownloadRateLimit() <= 0L && object.getUploadRateLimit() <= 0L) continue;
            client.setFirstSeen(client.getLastSeen());
            object4 = object5 = com.tp_link.eap.b.b.a.b((String)object3);
            synchronized (object4) {
                this.v.refreshClient(client);
            }
        }
    }

    private void E(JsonParser jsonParser) throws IOException {
        ArrayList<AccessSubnetGroup> arrayList = new ArrayList<AccessSubnetGroup>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            AccessSubnetGroup accessSubnetGroup = (AccessSubnetGroup)jsonParser.readValueAs(AccessSubnetGroup.class);
            accessSubnetGroup.setGroupName(com.tp_link.eap.util.a.e.e((String)accessSubnetGroup.getGroupName()));
            arrayList.add(accessSubnetGroup);
        }
        this.w.addSubnetGroups(arrayList);
    }

    private void F(JsonParser jsonParser) throws IOException {
        JsonToken jsonToken;
        block6: while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_OBJECT) {
            if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (string) {
                case "operator": {
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        Operator operator = (Operator)jsonParser.readValueAs(Operator.class);
                        operator.setName(com.tp_link.eap.util.a.e.e((String)operator.getName()));
                        operator.setPassword(com.tp_link.eap.util.a.e.e((String)operator.getPassword()));
                        this.i.save((Object)operator);
                    }
                    continue block6;
                }
            }
            a.warn("Restoring Hotspot data, unrecognized filed {}", (Object)jsonParser.getCurrentName());
        }
    }

    private void G(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            LocalUser localUser = (LocalUser)jsonParser.readValueAs(LocalUser.class);
            localUser.setMacAddress(com.tp_link.eap.util.a.e.e((String)localUser.getMacAddress()));
            localUser.setExpirationTime(com.tp_link.eap.util.a.e.e((String)localUser.getExpirationTime()));
            this.K.updateUser(localUser);
        }
    }

    private void H(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Voucher voucher = (Voucher)jsonParser.readValueAs(Voucher.class);
            voucher.setCode(com.tp_link.eap.util.a.e.e((String)voucher.getCode()));
            this.L.updateVoucher(voucher);
        }
    }

    private void I(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            PortalWebUIPicture portalWebUIPicture = (PortalWebUIPicture)jsonParser.readValueAs(PortalWebUIPicture.class);
            this.N.savePictureRecord(portalWebUIPicture);
        }
    }

    private void J(JsonParser jsonParser) throws IOException {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Map map = (Map)jsonParser.readValueAs(Map.class);
            arrayList.add(map);
        }
        this.M.addMaps(arrayList);
    }

    private void K(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            JsonToken jsonToken;
            String string = null;
            String string2 = null;
            block9: while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_OBJECT) {
                if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
                String string3 = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (string3) {
                    case "fileId": {
                        string = jsonParser.getValueAsString();
                        continue block9;
                    }
                    case "fileData": {
                        string2 = jsonParser.getValueAsString();
                        continue block9;
                    }
                }
                a.warn("Restoring picture file, unrecognized filed {}", (Object)jsonParser.getCurrentName());
            }
            if (StringUtils.isEmpty(string)) continue;
            if (this.N.checkGridFsReachMaxSize() || StringUtils.isEmpty(string2)) {
                this.N.delPictureRecordByFileId(string);
                continue;
            }
            this.N.savePictureBase64FileToGridfs(string, string2);
        }
    }

    private void L(JsonParser jsonParser) throws IOException {
        if (com.tp_link.eap.util.l.b()) {
            return;
        }
        CloudKeyEntry cloudKeyEntry = (CloudKeyEntry)jsonParser.readValueAs(CloudKeyEntry.class);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"params", (Object)com.tp_link.eap.util.a.b.a((Object)cloudKeyEntry));
        this.O.setCloudKeyBasicConfig(null, jSONObject);
        this.O.setCloudKeyNetworkConfig(null, jSONObject);
    }

    private void M(JsonParser jsonParser) throws IOException {
        ArrayList<Guest> arrayList = new ArrayList<Guest>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Guest guest = (Guest)jsonParser.readValueAs(Guest.class);
            if (StringUtils.isEmpty((Object)guest.getSite())) {
                a.debug("Guest site is empty");
                continue;
            }
            com.tp_link.eap.d.b.b((String)guest.getSite());
            if (StringUtils.isEmpty((Object)guest.getSsidName()) || StringUtils.isEmpty((Object)guest.getWlanId()) || null == guest.getRadioId()) {
                a.debug("Guest ssidName {}, wlanId {}, radioId {} illegal.", new Object[]{guest.getSsidName(), guest.getWlanId(), guest.getRadioId()});
                continue;
            }
            Ssid ssid = this.E.getSsidByName(guest.getSsidName(), guest.getWlanId(), guest.getRadioId());
            if (null == ssid) {
                a.debug("Cannot find ssid by name {}, wlanId {} and radioId {}", new Object[]{guest.getSsidName(), guest.getWlanId(), guest.getRadioId()});
                continue;
            }
            guest.setSsidId(ssid.getIdInt());
            arrayList.add(guest);
            if (arrayList.size() < 1000) continue;
            this.P.addGuests(arrayList);
            arrayList.clear();
        }
        this.P.addGuests(arrayList);
    }

    private void N(JsonParser jsonParser) throws IOException {
        ArrayList<ClientHistory> arrayList = new ArrayList<ClientHistory>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            ClientHistory clientHistory = (ClientHistory)jsonParser.readValueAs(ClientHistory.class);
            arrayList.add(clientHistory);
            if (arrayList.size() < 1000) continue;
            this.Q.addHistories(arrayList);
            arrayList.clear();
        }
        this.Q.addHistories(arrayList);
    }

    private void O(JsonParser jsonParser) throws IOException {
        ArrayList<LogInfo> arrayList = new ArrayList<LogInfo>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            LogInfo logInfo = (LogInfo)jsonParser.readValueAs(LogInfo.class);
            arrayList.add(logInfo);
            if (arrayList.size() < 1000) continue;
            this.R.addLogs(arrayList);
            arrayList.clear();
        }
        this.R.addLogs(arrayList);
    }

    private void P(JsonParser jsonParser) throws IOException {
        ArrayList<AlertInfo> arrayList = new ArrayList<AlertInfo>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            AlertInfo alertInfo = (AlertInfo)jsonParser.readValueAs(AlertInfo.class);
            arrayList.add(alertInfo);
            if (arrayList.size() < 1000) continue;
            this.S.addAlerts(arrayList);
            arrayList.clear();
        }
        this.S.addAlerts(arrayList);
    }

    private void Q(JsonParser jsonParser) throws IOException {
        ArrayList<StatRAHourly> arrayList = new ArrayList<StatRAHourly>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            StatRAHourly statRAHourly = (StatRAHourly)jsonParser.readValueAs(StatRAHourly.class);
            arrayList.add(statRAHourly);
            if (arrayList.size() < 1000) continue;
            this.T.addStatRaHourly(arrayList);
            arrayList.clear();
        }
        this.T.addStatRaHourly(arrayList);
    }

    private void R(JsonParser jsonParser) throws IOException {
        ArrayList<StatRADaily> arrayList = new ArrayList<StatRADaily>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            StatRADaily statRADaily = (StatRADaily)jsonParser.readValueAs(StatRADaily.class);
            arrayList.add(statRADaily);
            if (arrayList.size() < 1000) continue;
            this.T.addStatRaDaily(arrayList);
            arrayList.clear();
        }
        this.T.addStatRaDaily(arrayList);
    }

    private void S(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            StatLifeClient statLifeClient = (StatLifeClient)jsonParser.readValueAs(StatLifeClient.class);
            this.T.addStatLifeClient(statLifeClient);
        }
    }

    private void h() {
        this.i();
        this.j();
        List<Site> list = this.n.getSites();
        for (Site site : list) {
            this.a(site);
            this.b(site);
            this.c(site);
            this.d(site);
            this.e(site);
        }
        this.k();
    }

    private void i() {
        List<Site> list = this.n.getSites();
        if (CollectionUtils.isEmpty(list)) {
            a.warn("After restore, site is empty");
            Site site = new Site();
            site.setSystemDefault(true);
            site.setSiteName("Default");
            site.setName("Default");
            this.n.addSite(site);
        }
    }

    private void j() {
        List list = this.s.getAll();
        if (CollectionUtils.isEmpty((Collection)list)) {
            a.warn("After restore, privilege is empty");
            List list2 = this.o.getAll();
            for (User user : list2) {
                Privilege privilege = new Privilege();
                privilege.setUserName(user.getName());
                privilege.setSiteName("Default");
                privilege.setRole(user.getRole());
                list.add(privilege);
            }
            this.o.resetDefaultUserLastSite();
            this.f();
            this.g();
        }
    }

    private void a(Site site) {
        com.tp_link.eap.d.b.b((String)site.getSiteName());
        List<WlanGroup> list = this.H.getAllBySite();
        if (CollectionUtils.isEmpty(list)) {
            a.warn("After restore, wlan group is empty on site {}", (Object)site.getSiteName());
            WlanGroup wlanGroup = new WlanGroup();
            wlanGroup.setIsDefault(Boolean.valueOf(true));
            wlanGroup.setSite(site.getSiteName());
            wlanGroup.setMaxSsids(com.tp_link.eap.util.e.bA);
            wlanGroup.setName("Default");
            wlanGroup.setRadioId(Integer.valueOf(0));
            this.H.saveWlanGroup(wlanGroup, false);
            WlanGroup wlanGroup2 = new WlanGroup();
            wlanGroup2.setIsDefault(Boolean.valueOf(true));
            wlanGroup2.setSite(site.getSiteName());
            wlanGroup2.setMaxSsids(com.tp_link.eap.util.e.bA);
            wlanGroup2.setName("Default");
            wlanGroup2.setRadioId(Integer.valueOf(1));
            this.H.saveWlanGroup(wlanGroup2, false);
        }
    }

    private void b(Site site) {
        com.tp_link.eap.d.b.b((String)site.getSiteName());
        SshSetting sshSetting = this.A.getSshSetting();
        if (null == sshSetting) {
            a.warn("After restore, ssh setting is null on site {}", (Object)site.getSiteName());
            sshSetting = new SshSetting();
            sshSetting.setSite(site.getSiteName());
            sshSetting.setSshenable(Boolean.valueOf(false));
            sshSetting.setSshserverPort(Integer.valueOf(22));
            com.tp_link.eap.d.b.b((String)sshSetting.getSite());
            this.A.saveSshSetting(sshSetting, false);
        }
    }

    private void c(Site site) {
        com.tp_link.eap.d.b.b((String)site.getSiteName());
        ManagementVlanSetting managementVlanSetting = this.A.getManagementVlanSetting();
        if (null == managementVlanSetting) {
            a.warn("After restore, management vlan setting is null on site {}", (Object)site.getSiteName());
            managementVlanSetting = new ManagementVlanSetting();
            managementVlanSetting.setSite(site.getSiteName());
            managementVlanSetting.setManagementVlanEnable(Boolean.valueOf(false));
            managementVlanSetting.setManagementVlanId(Integer.valueOf(1));
            com.tp_link.eap.d.b.b((String)managementVlanSetting.getSite());
            this.A.saveManagementVlanSetting(managementVlanSetting, false);
        }
    }

    private void d(Site site) {
        com.tp_link.eap.d.b.b((String)site.getSiteName());
        BandSteering bandSteering = this.A.getBandSteering();
        if (null == bandSteering) {
            a.warn("After restore, band steering is null on site {}", (Object)site.getSiteName());
            this.A.initBandSteering();
        }
    }

    private void e(Site site) {
        com.tp_link.eap.d.b.b((String)site.getSiteName());
        UserAccountSetting userAccountSetting = this.A.getUserAccountSetting();
        if (null == userAccountSetting) {
            a.warn("After restore, user account is null on site {}", (Object)site.getSiteName());
            userAccountSetting = new UserAccountSetting();
            userAccountSetting.setOldName("admin");
            userAccountSetting.setOldPassword("admin");
            userAccountSetting.setUserName("admin");
            userAccountSetting.setPassword("admin");
            this.A.initUserAccountSetting(userAccountSetting);
        }
    }

    private void k() {
        HistoryRetentionSetting historyRetentionSetting = this.A.getHistoryRetentionSetting();
        if (null == historyRetentionSetting) {
            a.warn("After restore, history retention setting is null");
            historyRetentionSetting = new HistoryRetentionSetting();
            this.A.saveHistoryRetentionSetting(historyRetentionSetting);
        }
    }

    private boolean c(String string) {
        if (null == this.g) {
            return false;
        }
        try {
            return com.tp_link.eap.util.l.b((String)this.g) >= com.tp_link.eap.util.l.b((String)string);
        }
        catch (Exception exception) {
            a.warn("Parse Version wrong, restoreFileVersion is {}, and target version is {}", (Object)this.g, (Object)string);
            return false;
        }
    }

    static /* synthetic */ int a(RestoreServiceImpl restoreServiceImpl) {
        return restoreServiceImpl.e();
    }

    static /* synthetic */ Logger a() {
        return a;
    }

    static /* synthetic */ com.tp_link.eap.monitor.record.service.b b(RestoreServiceImpl restoreServiceImpl) {
        return restoreServiceImpl.l;
    }

    static /* synthetic */ com.tp_link.eap.monitor.monitor.service.b c(RestoreServiceImpl restoreServiceImpl) {
        return restoreServiceImpl.k;
    }
}

